﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.ComponentModel;
using System.Data;
using System.Threading;
using System.Drawing;

namespace PsgBase
{
    [Designer(typeof(System.Windows.Forms.Design.ControlDesigner))]
    public partial class psgDataGridView : DataGridView
    {
        #region Fields / Constructors 

        public string initial_value = string.Empty;
        string valueKey = string.Empty; string fieldKey = string.Empty;
        string current_value = string.Empty; string current_field = string.Empty;
        string fieldName = string.Empty;
        string servertablename = string.Empty, gridFieldKey = string.Empty;
        private DataTable table;
        int hmn_loop;
        bool admin = false;
        public bool bPopulateDataSource = true, bClickCheck = true;
        public int PsgSaveType = SaveType.Field;

        public void InitializeComponent()
        {
            System.Windows.Forms.DataGridViewCellStyle dataGridViewCellStyle1 = new System.Windows.Forms.DataGridViewCellStyle();
            ((System.ComponentModel.ISupportInitialize)(this)).BeginInit();
            this.SuspendLayout();
            // 
            // psgDataGridView
            // 
            this.BorderStyle = System.Windows.Forms.BorderStyle.None;
            dataGridViewCellStyle1.Alignment = System.Windows.Forms.DataGridViewContentAlignment.MiddleLeft;
            dataGridViewCellStyle1.BackColor = System.Drawing.SystemColors.Window;
            dataGridViewCellStyle1.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            dataGridViewCellStyle1.ForeColor = System.Drawing.SystemColors.ControlText;
            dataGridViewCellStyle1.SelectionBackColor = System.Drawing.Color.FromArgb(((int)(((byte)(128)))), ((int)(((byte)(128)))), ((int)(((byte)(255)))));
            dataGridViewCellStyle1.SelectionForeColor = System.Drawing.SystemColors.HighlightText;
            dataGridViewCellStyle1.WrapMode = System.Windows.Forms.DataGridViewTriState.False;
            this.DefaultCellStyle = dataGridViewCellStyle1;
            this.EditMode = System.Windows.Forms.DataGridViewEditMode.EditOnEnter;
            this.RowHeadersWidth = 25;
            this.RowTemplate.DefaultCellStyle.SelectionBackColor = System.Drawing.Color.FromArgb(((int)(((byte)(128)))), ((int)(((byte)(128)))), ((int)(((byte)(255)))));
            this.DataSourceChanged += new System.EventHandler(this.psgDataGridView_DataSourceChanged);
            this.CellClick += new System.Windows.Forms.DataGridViewCellEventHandler(this.psgDataGridView_CellContentClick);
            this.CellContentClick += new System.Windows.Forms.DataGridViewCellEventHandler(this.psgDataGridView_CellContentClick);
            this.CellEnter += new System.Windows.Forms.DataGridViewCellEventHandler(this.psgDataGridView_CellEnter);
            this.CellValidated += new System.Windows.Forms.DataGridViewCellEventHandler(this.psgDataGridView_CellValidated);
            this.CellValidating += new System.Windows.Forms.DataGridViewCellValidatingEventHandler(this.psgDataGridView_CellValidating);
            this.CellValueChanged += new System.Windows.Forms.DataGridViewCellEventHandler(this.psgDataGridView_CellValueChanged);
            this.CurrentCellDirtyStateChanged += new System.EventHandler(this.psgDataGridView_CurrentCellDirtyStateChanged);
            this.DataBindingComplete += new System.Windows.Forms.DataGridViewBindingCompleteEventHandler(this.psgDataGridView_DataBindingComplete);
            this.DataError += new System.Windows.Forms.DataGridViewDataErrorEventHandler(this.psgDataGridView_DataError);
            this.RowsRemoved += new System.Windows.Forms.DataGridViewRowsRemovedEventHandler(this.psgDataGridView_RowsRemoved);
            this.VisibleChanged += new System.EventHandler(this.psgDataGridView_VisibleChanged);
            this.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.psgDataGridView_KeyPress);
            ((System.ComponentModel.ISupportInitialize)(this)).EndInit();
            this.ResumeLayout(false);

        }

        public psgDataGridView()
        {
            InitializeComponent();
        }

        #endregion

        #region Properties

        [Browsable(false)]
        public bool Admin
        {
            get { return admin; }
            set { admin = value; }
        }

        [Browsable(false)]
        public DataTable Table
        {
            get { return table; }
            set { table = value; }
        }

        [Category("PSG"), Browsable(false)]
        public string PsgValueKey
        {
            get { return valueKey; }
            set { valueKey = value; }
        }

        [Category("PSG")]
        public string PsgFieldKey
        {
            get { return fieldKey; }
            set { fieldKey = value; }
        }

        [Category("PSG"), Browsable(false)]
        public string PsgCurrent_Value
        {
            get { return current_value; }
            set { current_value = value; }
        }

        [Category("PSG"), Browsable(false)]
        public string PsgCurrent_Field
        {
            get { return current_field; }
            set { current_field = value; }
        }

        [Category("PSG")]
        public string PsgServerTableName
        {
            get { return servertablename; }
            set { servertablename = value; }
        }

        [Category("PSG")]
        public string PsgGridFieldKey
        {
            get { return gridFieldKey; }
            set { gridFieldKey = value; }
        }

        #endregion

        void psgDataGridView_DataSourceChanged(object sender, EventArgs e)
        {
            if (bPopulateDataSource)
            {
                if (this.DataSource != null && this.DataSource is DataTable)
                {
                    DataTable dtSource = (DataTable)this.DataSource, _dt = dtSource.Clone();
                    foreach (DataGridViewColumn col in this.Columns)
                    {
                        if (col is psgCheckBoxColumn || col is DataGridViewCheckBoxColumn)
                        {
                            _dt.Columns[col.DataPropertyName].MaxLength = -1;
                            _dt.Columns[col.DataPropertyName].DataType = typeof(bool);
                        }
                    }

                    foreach (DataRow row in dtSource.Rows)
                        _dt.Rows.Add(Base.psgIntf.CopyDataRow(_dt, row));

                    this.bPopulateDataSource = false;
                    this.DataSource = _dt;
                }
            }
        }

        private void SetCurrentPrimKey()
        {
            if (Base.psgIntf == null)
                return;

            if (this.CurrentRow != null && !this.IsCurrentRowDirty)
            {
                string _id = Convert.ToString((this.CurrentRow.Cells[GetFieldKey()].Value));
                Base.psgIntf.SetCurrentPK(this.PsgServerTableName, _id);
            }
        }

        public string GetFieldKey()
        {
            if (string.IsNullOrEmpty(this.PsgGridFieldKey))
                return this.PsgFieldKey;
            else
                return this.PsgGridFieldKey;
        }

        private void psgDataGridView_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == Convert.ToChar(13))
            {
                this.psgDataGridView_CellValidated(sender, null);
            }
        }

        private void psgDataGridView_CellEnter(object sender, DataGridViewCellEventArgs e)
        {
            if (!Base.psgIntf.ValidGridCellEnter(this, e))
                return;

            if (this.Rows[e.RowIndex] != null)
                this.Rows[e.RowIndex].Selected = true;

            string val = Convert.ToString(((DataGridView)sender).Rows[e.RowIndex].Cells[e.ColumnIndex].Value);
            this.initial_value = string.IsNullOrEmpty(val) ? string.Empty : val.Trim();
            this.PsgCurrent_Value = this.initial_value;
            this.PsgCurrent_Field = ((DataGridView)sender).Columns[e.ColumnIndex].DataPropertyName;
            this.PsgValueKey = Convert.ToString(((DataGridView)sender).Rows[e.RowIndex].Cells[GetFieldKey()].Value);
            SetCurrentPrimKey();
        }

        //not combobox
        private void psgDataGridView_CellValidating(object sender, DataGridViewCellValidatingEventArgs e)
        {
            if (this.CurrentRow == null || this.CurrentCell == null || this.SelectedRows.Count == 0)
                return;

            DataGridViewColumn col = ((DataGridView)sender).Columns[e.ColumnIndex];

            if (col.ReadOnly)
                return;

            if (col is psgComboBoxColumn || col is DataGridViewComboBoxColumn)
                return;

            string val = string.Empty;
            if (col is psgCheckBoxColumn || col is DataGridViewCheckBoxColumn)
                val = Convert.ToString(Convert.ToInt32(Convert.ToBoolean(e.FormattedValue)));
            if (col is psgComboBoxColumn || col is DataGridViewComboBoxColumn)
                val = Convert.ToString(e.FormattedValue);
            if (col is psgTextBoxColumn || col is DataGridViewTextBoxColumn)
                val = Convert.ToString(e.FormattedValue);
            if (col is psgDateTimeColumn)
                val = Convert.ToString(this[e.ColumnIndex, e.RowIndex].Value);

            if (col is psgTextBoxColumn && ((psgTextBoxColumn)col).PsgNumeric && string.IsNullOrEmpty(val))
            {
                val = "0";
                this[e.ColumnIndex, e.RowIndex].Value = 0;
            }


            this.PsgCurrent_Value = string.IsNullOrEmpty(val) ? string.Empty : val.Trim();
            this.PsgCurrent_Field = ((DataGridView)sender).Columns[e.ColumnIndex].DataPropertyName;
            SetCurrentPrimKey();

            if (psgUpdate(sender, col))
            {
                hmn_loop = 0;
                while (Intf.cmdResult != PsgMsg.OK && this.hmn_loop <= 200)
                {
                    Thread.Sleep(30);
                    this.hmn_loop = this.hmn_loop + 1;
                }

                if (Intf.cmdResult != PsgMsg.OK)
                {
                    MessageBox.Show("Check server connectivity and try again!", "Server communication failed", MessageBoxButtons.OK);

                    if (this.CurrentRow != null && this.CurrentCell != null)
                        this.CurrentRow.Cells[this.CurrentCell.ColumnIndex].Value = this.initial_value;

                    if (e != null)
                        e.Cancel = true;

                    Intf.cmdResult = PsgMsg.OK;
                    this.RefreshEdit();

                    return;
                }

                if (this.CurrentRow != null && this.CurrentCell != null &&
                    this.CurrentRow.Cells[this.CurrentCell.ColumnIndex].Value != null)
                {
                    this.initial_value = this.CurrentRow.Cells[this.CurrentCell.ColumnIndex].Value.ToString();
                }
            }
        }

        //combobox
        private void psgDataGridView_CellValidated(object sender, DataGridViewCellEventArgs e)
        {
            if (this.CurrentRow == null || this.CurrentCell == null || this.SelectedRows.Count == 0)
                return;

            DataGridViewColumn col = ((DataGridView)sender).Columns[e.ColumnIndex];

            if (col.ReadOnly)
                return;

            if (col is psgComboBoxColumn || col is DataGridViewComboBoxColumn)
            {
                string val = Convert.ToString(this[e.ColumnIndex, e.RowIndex].Value);
                this.PsgCurrent_Value = string.IsNullOrEmpty(val) ? string.Empty : val.Trim();
                this.PsgCurrent_Field = ((DataGridView)sender).Columns[e.ColumnIndex].DataPropertyName;
                SetCurrentPrimKey();

                if (psgUpdate(sender, col))
                    CheckUpdate();
            }
        }

        //combobox
        private void psgDataGridView_CellValueChanged(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex < 0 || e.ColumnIndex < 0)
                return;

            if (this.CurrentRow == null || this.CurrentCell == null || this.SelectedRows.Count == 0)
                return;

            DataGridViewColumn col = ((DataGridView)sender).Columns[e.ColumnIndex];
            if (col.ReadOnly)
                return;

            if (this.CurrentRow.Cells[col.Name].Value == null || this.CurrentRow.Cells[col.Name].Value == DBNull.Value)
                return;

            if (col is psgComboBoxColumn || col is DataGridViewComboBoxColumn)
            {
                string val = Convert.ToString(this[e.ColumnIndex, e.RowIndex].Value);
                this.PsgCurrent_Value = string.IsNullOrEmpty(val) ? string.Empty : val.Trim();
                this.PsgCurrent_Field = ((DataGridView)sender).Columns[e.ColumnIndex].DataPropertyName;
                SetCurrentPrimKey();

                if (psgUpdate(sender, col))
                    CheckUpdate();
            }
        }

        public bool psgUpdate(object senderGrid, DataGridViewColumn col)
        {
            if (col is psgCheckBoxColumn || col is DataGridViewCheckBoxColumn)
            {
                if (Utils.StringEquals(this.PsgCurrent_Value, Convert.ToInt32(Convert.ToBoolean(initial_value))))
                    return false;

                    Base.kv = Base.GetParameters(((psgDataGridView)senderGrid).PsgValueKey, "C");
                    Base.value = Base.GetParameters(this.PsgCurrent_Value, "I");
                    if (Admin)
                    {
                        Base.psgIntf.send_command("PSGSHORTUPDATE#'" + ((psgDataGridView)senderGrid).PsgServerTableName + "','" + ((psgDataGridView)senderGrid).PsgFieldKey
                            + "'," + Base.kv + ",'" + this.PsgCurrent_Field + "'," + Base.value);
                    }
                    else
                    {
                        Base.psgIntf.send_command("UPDATEFIELD#'" + ((psgDataGridView)senderGrid).PsgServerTableName + "','" + ((psgDataGridView)senderGrid).PsgFieldKey
                            + "'," + Base.kv + ",'" + this.PsgCurrent_Field + "'," + Base.value);
                    }

                    bClickCheck = true;
                    return true;
            }

            if (col is psgTextBoxColumn || col is psgComboBoxColumn ||
                col is DataGridViewTextBoxColumn || col is DataGridViewComboBoxColumn)
            {
                if (Utils.StringEquals(this.PsgCurrent_Value, initial_value))
                    return false;

                Base.kv = Base.GetParameters(((psgDataGridView)senderGrid).PsgValueKey, "C");
                Base.value = Base.GetParameters(this.PsgCurrent_Value, "C");

                if (Admin)
                {
                    Base.psgIntf.send_command("PSGSHORTUPDATE#'" + ((psgDataGridView)senderGrid).PsgServerTableName + "','" + ((psgDataGridView)senderGrid).PsgFieldKey
                        + "'," + Base.kv + ",'" + this.PsgCurrent_Field + "'," + Base.value);
                }
                else
                {
                    Base.psgIntf.send_command("UPDATEFIELD#'" + ((psgDataGridView)senderGrid).PsgServerTableName + "','" + ((psgDataGridView)senderGrid).PsgFieldKey
                        + "'," + Base.kv + ",'" + this.PsgCurrent_Field + "'," + Base.value);
                }

                return true;
            }

            if (col is psgDateTimeColumn)
            {
                if (Utils.StringEquals(this.PsgCurrent_Value, initial_value))
                    return false;

                Base.kv = Base.GetParameters(((psgDataGridView)senderGrid).PsgValueKey, "C");
                Base.value = Base.GetParameters(this.PsgCurrent_Value, "D");
                if (Admin)
                {
                    Base.psgIntf.send_command("PSGSHORTUPDATE#'" + ((psgDataGridView)senderGrid).PsgServerTableName + "','" + ((psgDataGridView)senderGrid).PsgFieldKey
                        + "'," + Base.kv + ",'" + this.PsgCurrent_Field + "'," + Base.value);
                }
                else
                {
                    Base.psgIntf.send_command("UPDATEFIELD#'" + ((psgDataGridView)senderGrid).PsgServerTableName + "','" + ((psgDataGridView)senderGrid).PsgFieldKey
                        + "'," + Base.kv + ",'" + this.PsgCurrent_Field + "'," + Base.value);
                }

                return true;
            }

            return false;
        }
        public void CheckUpdate()
        {
            hmn_loop = 0;
            while (Intf.cmdResult != "OK" && this.hmn_loop <= 200)
            {
                Thread.Sleep(30);
                this.hmn_loop = this.hmn_loop + 1;
            }


            if (Intf.cmdResult != "OK")
            {
                MessageBox.Show("Check server connectivity and try again!", "Server communication failed", MessageBoxButtons.OK);

                if (this.CurrentRow != null && this.CurrentCell != null)
                    this.CurrentRow.Cells[this.CurrentCell.ColumnIndex].Value = this.initial_value;

                this.RefreshEdit();
            }

            if (this.CurrentRow != null && this.CurrentCell != null &&
                this.CurrentRow.Cells[this.CurrentCell.ColumnIndex].Value != null)
            {
                this.initial_value = this.CurrentRow.Cells[this.CurrentCell.ColumnIndex].Value.ToString();
            }
        }

        private string LabelIntl(psgTextBoxColumn col)
        {
            if (this.DesignMode)
                return col.HeaderText;

            if (Base.tableIntl == null || Base.tableIntl.Rows.Count == 0)
                return col.HeaderText;

            return Base.GetIntl(col.PsgIntl, col.HeaderText);
        }
        private string LabelIntl(psgComboBoxColumn col)
        {
            if (this.DesignMode)
                return col.HeaderText;

            if (Base.tableIntl == null || Base.tableIntl.Rows.Count == 0)
                return col.HeaderText;

            return Base.GetIntl(col.PsgIntl, col.HeaderText);
        }

        private void psgDataGridView_DataBindingComplete(object sender, DataGridViewBindingCompleteEventArgs e)
        {
            //if (this.Columns.Count > 0 && this.SortedColumn == null)
            //{
            //    if (this.Columns[1].Visible &&
            //        this.Columns[1].SortMode != DataGridViewColumnSortMode.NotSortable)
            //    {
            //        this.Sort(this.Columns[1], ListSortDirection.Ascending);
            //        this.Columns[1].HeaderCell.SortGlyphDirection = SortOrder.Ascending;
            //    }
            //}

            foreach (DataGridViewColumn col in this.Columns)
            {
                switch (col.GetType().Name.Trim().ToLower())
                {
                    case "psgtexteditcolumn":
                        col.HeaderText = LabelIntl((psgTextBoxColumn)col);
                        break;
                    case "psgcombocolumn":
                        col.HeaderText = LabelIntl((psgComboBoxColumn)col);
                        break;
                }

                col.HeaderText = Utils.ToUpperFirstLetter(col.HeaderText);
                col.HeaderText = col.HeaderText.Replace('_', ' ');
                col.Width = Math.Max(col.Width, col.HeaderText.Length * 8);

                if (!string.IsNullOrEmpty(col.HeaderText.Trim()))
                {
                    if (col.HeaderText.Substring(col.HeaderText.Length - 2, 2).ToLower() == "id")
                        col.Visible = false;
                    if (col.HeaderText.Substring(col.HeaderText.Length - 1, 1).ToLower() == "_")
                        col.Visible = false;
                }
            }
        }
        private void psgDataGridView_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {
            if (this.CurrentRow != null)
                this.CurrentRow.Selected = true;

            if (e.RowIndex < 0 || e.ColumnIndex < 0)
                return;

            if (this.Rows[e.RowIndex] != null)
                this.Rows[e.RowIndex].Selected = true;

            if (!bClickCheck)
                return;

            if (this.CurrentRow == null || this.CurrentCell == null || this.SelectedRows.Count == 0)
                return;

            DataGridViewColumn col = this.Columns[e.ColumnIndex];
            if (col is psgCheckBoxColumn || col is DataGridViewCheckBoxColumn)
                bClickCheck = false;

            string val = Convert.ToString(((DataGridView)sender).Rows[e.RowIndex].Cells[e.ColumnIndex].Value);
            this.initial_value = string.IsNullOrEmpty(val) ? string.Empty : val.Trim();
            this.PsgCurrent_Value = this.initial_value;
            this.PsgCurrent_Field = ((DataGridView)sender).Columns[e.ColumnIndex].DataPropertyName;
            this.PsgValueKey = Convert.ToString(((DataGridView)sender).Rows[e.RowIndex].Cells[GetFieldKey()].Value);
            SetCurrentPrimKey();

            if (col != null)
            {
                switch (col.GetType().Name.Trim().ToLower())
                {
                    case "psgtexteditcolumn":
                        break;
                    case "psgcombocolumn":
                        if (e.ColumnIndex >= 0 && e.RowIndex >= 0)
                        {
                            DataGridViewComboBoxCell cell = (DataGridViewComboBoxCell)this[e.ColumnIndex, e.RowIndex];
                            this.CurrentCell = cell;
                            this.BeginEdit(true);
                            DataGridViewComboBoxEditingControl editingControl = (DataGridViewComboBoxEditingControl)this.EditingControl;
                            if (editingControl != null)
                                editingControl.DroppedDown = true;
                        }
                        break;
                }
            }
        }
        private void psgDataGridView_DataError(object sender, DataGridViewDataErrorEventArgs e)
        {
            // MessageBox.Show(e.Exception.Message);
        }
        private void psgDataGridView_RowsRemoved(object sender, DataGridViewRowsRemovedEventArgs e)
        {
            if (this.CurrentRow == null)
                return;

            this.Refresh();
        }
        private void psgDataGridView_CurrentCellDirtyStateChanged(object sender, EventArgs e)
        {
            this.CommitEdit(DataGridViewDataErrorContexts.Formatting);

            if (!this.Visible)
                return;

            if (this.CurrentRow == null || this.CurrentCell == null)
                return;
        }
        private void psgDataGridView_VisibleChanged(object sender, EventArgs e)
        {
            if (!this.Visible)
                return;

            if (this.Rows.Count == 0)
                return;

            if (this.CurrentRow != null)
            {
                this.CurrentRow.Selected = true;
                return;
            }

            if (this.SelectedRows.Count > 0)
            {
                this.SelectedRows[0].Selected = true;
                return;
            }

            this.Rows[0].Selected = true;
        }
    }
}
